#!/bin/bash
#
# Licence:    Open source / public domain
# Author:     Enkidu

if test -z "$1" ; then
	echo "Usage: gmp-average.sh <logfile>"
	exit 2
fi

if ! test -e "$1" ; then
	echo "Logfile $1 not found"
	exit 2
fi

CALCULATIONS=$(cat "$1" | sed -e "/^Now at /!d" | head -n 1 \
	| sed -e "s/^Now at .* milliseconds for //; s/ calculations.*//")

CALC_PRINT=$(echo "$CALCULATIONS" | sed -e "s/000$/'000/; s/000'/'000'/")

GMP_USED=$(cat "$1" | sed -e "/^Now at / !d; /gmp used/!d; s/^.*gmp used //; s/ times//")
if test -z "$GMP_USED" ; then
	GMP_USED=0
fi

# echo -n "Length of variable \$GMP_USED is "
# echo "${#GMP_USED} bytes"

MS_USED=$(cat "$1" | sed -e "/^Now at /!d; s/^.*(//; s/ milliseconds.*//")
N_LINES=$(cat "$1" | sed -e "/^Now at /!d" | wc -l)

TOTAL_USED=0
MS_TOTAL=0

for N in $GMP_USED ; do
	TOTAL_USED=$(($TOTAL_USED + $N))
done

for T in $MS_USED ; do
	MS_TOTAL=$(($MS_TOTAL + $T))
done

echo
echo -n "Average use of GMP for $CALC_PRINT calculations is "
AVG=$(echo "scale=5; ($TOTAL_USED / $N_LINES)" | bc)
echo "${AVG} times"

echo -n "Average time spent for $CALC_PRINT calculations is "
AVGT=$(echo "scale=2; ($MS_TOTAL / $N_LINES)" | bc)
echo "$AVGT milliseconds"

echo -n "Total time elapsed is "
HRS=$(($MS_TOTAL / 3600000))
if test -z "$HRS" ; then
	HRS=0
fi

REST=$(($MS_TOTAL - ($HRS * 3600000)))
MIN=$(($REST / 60000))
if test -z "$MIN" ; then
	MIN=0
fi

REST=$(($MS_TOTAL - ($HRS * 3600000) - ($MIN * 60000)))
SEC=$(echo "scale=3; $REST / 1000" | bc)

echo "${HRS}h ${MIN}m ${SEC}s"

echo
exit 0
